/*
 * Decompiled with CFR 0.152.
 */
package com.tino1b2be.cmdprograms;

import com.tino1b2be.audio.WavFileException;
import com.tino1b2be.dtmfdecoder.DTMFDecoderException;
import com.tino1b2be.dtmfdecoder.DTMFUtil;
import java.io.File;
import java.io.IOException;
import java.util.InputMismatchException;
import java.util.Scanner;

public class GenerateDTMF {
    private static int Fs;
    private static int toneDurr;
    private static int pauseDurr;
    private static char[] chars;
    private static Scanner sc;
    private static File file;

    public static void main(String[] args) throws IOException, WavFileException, DTMFDecoderException {
        GenerateDTMF.setVariables(args);
        System.out.println("Now generating the sequence.");
        DTMFUtil dtmf = new DTMFUtil(file, chars, Fs, toneDurr, pauseDurr);
        if (!dtmf.generate()) {
            throw new DTMFDecoderException("Something went wrong. Sequence could not be generated.");
        }
        System.out.println("Now exporting the file to \"" + file.getPath() + "\"");
        dtmf.export();
        System.out.println("Done.");
    }

    private static void setVariables(String[] args) {
        String[] ch2;
        String ch;
        if (args.length == 4) {
            String ch3 = args[0];
            chars = new char[ch3.length()];
            for (int i = 0; i < ch3.length(); ++i) {
                GenerateDTMF.chars[i] = ch3.charAt(i);
            }
            toneDurr = Integer.parseInt(args[1]);
            pauseDurr = Integer.parseInt(args[2]);
            Fs = Integer.parseInt(args[3]);
            file = new File(args[3]);
            return;
        }
        sc = new Scanner(System.in);
        while (true) {
            System.out.print("Please enter the sequence of DTMF characters to generate (no spaces between them) : ");
            ch = sc.nextLine();
            ch2 = ch.split(" ");
            if (ch2.length <= 1) break;
            System.err.println("No spaces between characters! Please try again.");
        }
        chars = new char[ch.length()];
        for (int i = 0; i < ch.length(); ++i) {
            GenerateDTMF.chars[i] = ch2[0].charAt(i);
        }
        while (true) {
            try {
                System.out.print("Please enter duration of each tone (in milliseconds) : ");
                toneDurr = sc.nextInt();
                System.out.print("Please enter the duration of each pause between tones (in milliseconds) : ");
                pauseDurr = sc.nextInt();
                System.out.print("Please enter the sampling frequency (>8kHz) : ");
                Fs = sc.nextInt();
            }
            catch (InputMismatchException e) {
                System.err.println("Please enter an integer value!");
                continue;
            }
            break;
        }
        System.out.print("Please enter the name of the output file. : ");
        sc = new Scanner(System.in);
        file = new File(sc.nextLine());
        sc.close();
    }
}

